﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CRR_Example_Client
{
	public enum ExecutionState
	{
		Before,
		Success,
		Error,
	};

	public class ExecutionLogEntry
	{
		public DateTime dtEntry { get; set; }
		public string strCommand { get; set; }
		public string time { get; set; }
		public ServiceReferences.iCResult result { get; set; }
		public string exception_text { get; set; }
		public bool? signature_match { get; set; }
		public string result_text
		{
			set { return; }
			get
			{
				if (!String.IsNullOrEmpty(exception_text))
				{
					return exception_text;
				}
				else if (result == null && String.IsNullOrEmpty(time))
				{
					return "";
				}
				else if (result == null)
				{
					return "Result: -- (Timeout)";
				}
				else
				{
					if (signature_match == false)
					{
						return "Result: " + result.status.ToString() + " (" + result.status_msg + ") <signature mismatch>";
					}
					return "Result: " + result.status.ToString() + " (" + result.status_msg + ")";
				}
			}
		}

		public ExecutionState state
		{
			set { return; }
			get
			{
				if (!String.IsNullOrEmpty(exception_text))
				{
					return ExecutionState.Error;
				}
				else if (result == null && String.IsNullOrEmpty(time))
				{
					return ExecutionState.Before;
				}
				else if (result == null)
				{
					return ExecutionState.Error;
				}
				else
				{
					if (result.status == 0) return ExecutionState.Success;
					else return ExecutionState.Error;
				}
			}
		}
	}
}
